<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Booking\Domain\IdBooking;
use App\Modules\PaxInformation\Infraestructure\MysqlPaxInformationRepository;
use App\Modules\PaxInformation\Application\Insert\PaxInformationInsertCommandHandler;
use App\Modules\PaxInformation\Application\Insert\PaxInformationInsert;
use App\Modules\PaxInformation\Application\Insert\PaxInformationInsertCommand;
use App\Modules\PaxInformation\Application\PaxInformationDeleter;
use App\Modules\PaxInformation\Application\PaxInformationFinder;
use App\Modules\PaxInformation\Application\PaxInformationIndexer;
use App\Modules\PaxInformation\Application\PaxInformationUpdater;
use App\Modules\PaxInformation\Domain\IdPaxInformation;
use App\Modules\PaxInformation\Domain\PaxInformationDateExpire;
use App\Modules\PaxInformation\Domain\PaxInformationDescription;
use App\Modules\PaxInformation\Domain\PaxInformationStatus;
use App\Modules\PaxInformation\Domain\UpdatePaxInformation;
use App\Modules\PaxInformation\Infraestructure\Validators\PaxInformationValidators;
use App\Modules\PaxInformationPassenger\Application\Insert\PaxInformationPassengerInsert;
use App\Modules\PaxInformationPassenger\Application\Insert\PaxInformationPassengerInsertCommand;
use App\Modules\PaxInformationPassenger\Application\Insert\PaxInformationPassengerInsertCommandHandler;
use App\Modules\PaxInformationPassenger\Application\PaxInformationPassengerIndexer;
use App\Modules\PaxInformationPassenger\Domain\IdPaxInformationPassenger;
use App\Modules\PaxInformationPassenger\Infraestructure\MysqlPaxInformationPassengerRepository;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Support\Facades\DB;

class PaxInformation extends Controller
{
    private $oDomain;
    private HistoryData $history;
    private HistoryData $historyPassenger;

    public function __construct()
    {
        $this->oDomain = "PaxInformation";
        $this->history = new HistoryData(HistoryTables::pax_information);
        $this->historyPassenger = new HistoryData(HistoryTables::pax_information_passenger);
    }

    public function insert(Request $Request)
    {
        $validator = (new LaravelValidator);
        $validator->validate($Request->all(), $this->oDomain, PaxInformationValidators::INSERT);
        $passList = ['PaxInformation_Passenger' => json_decode($Request->input('PaxInformation_Passenger'))];
        $validator->validate($passList, $this->oDomain, PaxInformationValidators::PAX_INFORMATION_PASSENGER);
        $passList = ['PaxInformation_Passenger' => json_decode($Request->input('PaxInformation_Passenger'))];
        
        $data = DB::select('call sp_admin_session_get(?,?)', [
            $Request->header('Token'),
            $Request->ip()
        ])[0];

        $oResponse = (new PaxInformationInsertCommandHandler(
            new PaxInformationInsert(new MysqlPaxInformationRepository)
        ))->__invoke(new PaxInformationInsertCommand(
            $Request->input('PaxInformation_Description'),
            $Request->input('PaxInformation_Remaining'),
            $Request->input('PaxInformation_DateExpire'),
            PaxInformationStatus::PENDING,
            $Request->input('Id_Booking'),
            $data->Response_Id_Admin
        ));
        $this->history->insert(
            (new PaxInformationIndexer(new MysqlPaxInformationRepository))
                ->__invoke(new IdPaxInformation($oResponse['Response_Data']['Id'])),
            $Request,
            $oResponse['Response_Data']['Id']
        );

        foreach ($passList['PaxInformation_Passenger'] as $passenger) {
            $paxInformation = (new PaxInformationPassengerInsertCommandHandler(
                new PaxInformationPassengerInsert(new MysqlPaxInformationPassengerRepository)
            ))->__invoke(new PaxInformationPassengerInsertCommand(
                $Request->input('PaxInformation_Remaining'),
                1,
                $oResponse['Response_Data']['Id'],
                $passenger->Id_Passenger,
            ));

            $this->historyPassenger->insert(
                (new PaxInformationPassengerIndexer(new MysqlPaxInformationPassengerRepository))
                    ->__invoke(new IdPaxInformationPassenger($paxInformation['Response_Data']['Id'])),
                $Request,
                $paxInformation['Response_Data']['Id']
            );
        }
        
        
        return ResponseBuilder::Response($oResponse);
    }

    public function update(Request $Request)
    {
        (new LaravelValidator)->validate($Request->all(), $this->oDomain, PaxInformationValidators::UPDATE);

        $this->history->obtainOld($Request->input('Id_PaxInformation'));

        $oResponse = (new PaxInformationUpdater(new MysqlPaxInformationRepository))->__invoke(
            new UpdatePaxInformation(
                new PaxInformationDateExpire($Request->input('PaxInformation_DateExpire')),
                new PaxInformationDescription($Request->input('PaxInformation_Description')),
                new PaxInformationStatus($Request->input('PaxInformation_Status')),
                new IdPaxInformation($Request->input('Id_PaxInformation'))
            )
        );

        $this->history->update(
            $Request->input('Id_PaxInformation'),
            $this->history->oldValue,
            [],
            $Request
        );
        return ResponseBuilder::Response($oResponse);
    }

    public function delete(Request $request, $Id)
    {
        $this->history->obtainOld($Id);

        $oResponse = (new PaxInformationDeleter(new MysqlPaxInformationRepository))(new IdPaxInformation($Id));
        $this->history->delete(
            $Id,
            $this->history->oldValue,
            $request
        );
        return ResponseBuilder::Response($oResponse);
    }

    public function index($Id)
    {
        $oResponse = (new PaxInformationIndexer(new MysqlPaxInformationRepository))(new IdPaxInformation($Id));
        return ResponseBuilder::Response($oResponse);
    }

    public function list($Id_Booking, $Action)
    {
        $oResponse = (new PaxInformationFinder(new MysqlPaxInformationRepository))(new IdBooking($Id_Booking), $Action);
        return ResponseBuilder::Response($oResponse);
    }
}
