<?php
namespace App\Http\Controllers\Owner\LeadBookingTour;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\LeadBookingTour\Application\Create\LeadBookingTourInserterQuery;
use App\Modules\LeadBookingTour\Application\Create\LeadBookingTourInserterResponse;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\LeadBookingTour\Infraestructure\LeadBookingTourValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadBookingTourInsertController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "LeadBookingTour";
        $this->history = new HistoryData(HistoryTables::LEAD_BOOKING_TOUR);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, LeadBookingTourValidators::INSERT);
        /** @var LeadBookingTourInserterResponse $response */
        $response = $this->queryBus->ask(new LeadBookingTourInserterQuery(
            $request->input('LeadBookingTour_DateStart'),
            $request->input('LeadBookingTour_PickUp'),
            $request->input('LeadBookingTour_Type'),
            $request->input('LeadBookingTour_NoPax'),
            $request->input('LeadBookingTour_Group'),
            $request->input('LeadBookingTour_Status'),
            $request->input('Id_LeadBooking'),
            $request->input('Id_Package'),
            $request->input('Id_Tour')
        ));
        $this->history->insertBasic($request, $response->response()['Response_Data']['Id']);

        return ResponseBuilder::Response($response->response());
    }
}
