<?php
namespace App\Http\Controllers\Owner\LeadBookingService;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\LeadBookingService\Application\Update\LeadBookingServiceUpdaterQuery;
use App\Modules\LeadBookingService\Application\Update\LeadBookingServiceUpdaterResponse;
use App\Modules\LeadBookingService\Infraestructure\LeadBookingServiceValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadBookingServiceUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "LeadBookingService";
        $this->history = new HistoryData(HistoryTables::LEAD_BOOKING);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, LeadBookingServiceValidators::UPDATE);

        $this->history->obtainOld($request->input("Id_LeadBookingService"));

        /** @var LeadBookingServiceUpdaterResponse $response */
        $response = $this->queryBus->ask(new LeadBookingServiceUpdaterQuery(
            $request->input('Id_LeadBookingService'),
            $request->input('LeadBookingService_Quantity'),
            $request->input('LeadBookingService_Type'),
            $request->input('LeadBookingService_Status'),
            $request->input('Id_LeadBookingTour'),
            $request->input('Id')
        ));

        $this->history->updateBasic($request->input("Id_LeadBookingService"), $request);
        return ResponseBuilder::Response($response->response());
    }
}
