<?php
namespace App\Http\Controllers\Owner\GroupProvider;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ParamsValidator;
use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use Illuminate\Support\Facades\DB;

final class InsertAll extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->oDomain = "Group Provider";
        $this->history = new HistoryData(HistoryTables::group_provider);
    }

    public function __invoke(Request $Request)
    {
        $oSucces    = true;
        $oResponse  = array();
        $oValParams = [
            'Id_Group'  => 'required|int',
            'Provider'  => 'required|string'
        ];
        
        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
                
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $provider = json_decode($Request->input("Provider"));

            for ($k = 0; $k < count($provider); $k++) {
                $oParam = [
                    $provider[$k]->GroupProvider_Type,
                    $Request->input("Id_Group"),
                    $provider[$k]->Id_Provider
                ];

                $oData = DB::select('call sp_group_provider_insert(?,?,?)', $oParam);
                
                if ($oData[0]->Response_Success == 0) {
                    $oSucces = false;
                    break;
                }
                $this->history->insert(
                    [[
                        'GroupProvider_Type' => $provider[$k]->GroupProvider_Type,
                        'Id_Group' => $Request->input("Id_Group"),
                        'Id_Provider' => $provider[$k]->Id_Provider
                    ]],
                    $Request,
                    $Request->input("Id_Group")
                );
            }

            if ($oSucces == true) {
                $oData = array(
                    array(
                        "Response_Status"   => 200,
                        "Response_Code"     => 200,
                        "Response_Message"  => "Pasajeros guardados con éxito",
                        "Response_Reason"   => null
                    )
                );

                $oData = json_decode(json_encode($oData));
            }

            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }
}
