<?php
namespace App\Http\Controllers\Owner\Group;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\Group\Application\GroupReviewList;
use App\Modules\Group\Domain\GroupDateEnd;
use App\Modules\Group\Domain\GroupDateStart;
use App\Modules\Group\Infraestructure\GroupValidators;
use App\Modules\Group\Infraestructure\MysqlGroupReviewListRepository;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Http\Request;

final class ReviewList extends Controller
{
    public function __construct()
    {
        $this->oDomain = 'Group';
    }

    public function __invoke(Request $Request)
    {
        (new LaravelValidator)->validate($Request->all(), $this->oDomain, GroupValidators::REVIEW_LIST);
        $response = (new GroupReviewList(new MysqlGroupReviewListRepository))->__invoke(
            new GroupDateStart($Request->input('Group_DateStart')),
            new GroupDateEnd($Request->input('Group_DateEnd'))
        );
        return ResponseBuilder::Response($response);
    }
}
