<?php
namespace App\Http\Controllers\Owner\ExternalUserPassenger;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\ExternalUserPassenger\Application\ExternalUserPassengerIndexer;
use App\Modules\ExternalUserPassenger\Domain\IdExternalUserPassenger;
use App\Modules\ExternalUserPassenger\Infraestructure\MysqlExternalUserPassengerRepository;

class ExternalUserPassengerIndexController extends Controller
{
    public function __construct()
    {
    }

    public function __invoke($Id)
    {
        $response = (new ExternalUserPassengerIndexer(new MysqlExternalUserPassengerRepository()))
            ->__invoke(new IdExternalUserPassenger($Id));

        return ResponseBuilder::Response($response);
    }
}
