<?php
namespace App\Http\Controllers\Owner\ExternalUser;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\ExternalUser\Application\ExternalUserIndexer;
use App\Modules\ExternalUser\Domain\IdExternalUser;
use App\Modules\ExternalUser\Infraestructure\MysqlExternalUserRepository;

class ExternalUserIndexController extends Controller
{
    public function __construct()
    {
    }

    public function __invoke($Id)
    {
        $response = (new ExternalUserIndexer(new MysqlExternalUserRepository()))
            ->__invoke(new IdExternalUser($Id));

        return ResponseBuilder::Response($response);
    }
}
