<?php
namespace App\Http\Controllers\Owner\ExternalReviewProvider;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\ExternalReviewProvider\Application\ExternalReviewProviderDeleter;
use App\Modules\ExternalReviewProvider\Domain\IdExternalReviewProvider;
use App\Modules\ExternalReviewProvider\Infraestructure\MysqlExternalReviewProviderRepository;

class ExternalReviewProviderDeleteController extends Controller
{
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->history = new HistoryData(HistoryTables::EXTERNAL_REVIEW);
    }

    public function __invoke(Request $Request, int $Id)
    {
        $this->history->obtainOld($Id);

        $response = (new ExternalReviewProviderDeleter(new MysqlExternalReviewProviderRepository()))
            ->__invoke(new IdExternalReviewProvider($Id));

        $this->history->deleteBasic($Id, $Request);

        return ResponseBuilder::Response($response);
    }
}
