<?php
namespace App\Http\Controllers\Owner\Admin;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\Admin\Application\Update\AdminUpdaterQuery;
use App\Modules\Admin\Application\Update\AdminUpdaterResponse;
use App\Modules\Admin\Infrastructure\AdminValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class AdminUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "Admin";
        $this->history = new HistoryData(HistoryTables::LEAD);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, AdminValidators::INSERT);

        $this->history->obtainOld($request->input("Id_Admin"));

        /** @var AdminUpdaterResponse $response */
        $response = $this->queryBus->ask(new AdminUpdaterQuery(
            $request->input('Id_Admin'),
            $request->input('Admin_Name'),
            $request->input('Admin_LastName'),
            $request->input('Admin_Gender'),
            $request->input('Admin_Email'),
            $request->input('Admin_PhoneCode'),
            $request->input('Admin_Phone'),
            $request->input('Admin_NoDocument'),
            $request->input('Admin_Address'),
            $request->input('Admin_ContactName'),
            $request->input('Admin_ContactPhone'),
            $request->input('Admin_Type'),
            $request->input('Admin_Status'),
            $request->input('Id_TypeDocument'),
            $request->input('Id_UserCountry'),
        ));

        $this->history->updateBasic($request->input("Id_Admin"), $request);
        return ResponseBuilder::Response($response->response());
    }
}
