<?php
namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;

use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Mail\c_Mail_User;
use App\Providers\BookingMailSender;
use Illuminate\Support\Facades\Mail;
use Intervention\Image\ImageManagerStatic as Image;


class c_User extends Controller
{
	private $oDomain;

	public function __construct()
	{
		$this->oDomain = "User";
	}

	public function Insert(Request $Request) {
        $Password  = array();
		$oResponse  = array();
		$oValParams = array(    'User_Name'             => 'required|string|max:100',
                                'User_LastName'         => 'required|string|max:100',
                                'User_Email'            => 'required|string|max:250',
                                'User_Phone'		    => 'required|int',
                                'Id_UserCountry'        => 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {			
			$oParam = array(    Str::title( $Request->input("User_Name")),
								Str::title( $Request->input("User_LastName")),								
                                            $Request->input("User_Email"),
                                            $Request->input("User_Phone"),
                                            $Request->input("Id_UserCountry")
							);
			$oData = DB::select('call sp_client_user_insert(?,?,?,?,?)',$oParam);

            
			//  RESPONSE
			if($oData[0]->Response_Success == 1){
				//$Password[0]=$oData[0]->Response_Password;
			}else{
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= $Password;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
		
	}

	public function Update(Request $Request) {
		$oResponse  = array();
		$oValParams = array(    'Id_User'				=> 'required|int',
								'User_Name'				=> 'required|string|max:100',
								'User_LastName'			=> 'required|string|max:100',
								'User_Email'			=> 'required|string|max:250',
								'User_Phone'			=> 'required|int',
								'Id_UserCountry'		=> 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {			
			$oParam = array(    			$Request->input("Id_User"),
								Str::title( $Request->input("User_Name")),
								Str::title( $Request->input("User_LastName")),								
											$Request->input("User_Email"),
											$Request->input("User_Phone"),
											$Request->input("Id_UserCountry")
							);
			$oData = DB::select('call sp_client_user_update(?,?,?,?,?,?)',$oParam);

			//  RESPONSE
			if($oData[0]->Response_Success == 1){
				
			}else{
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);

	}

	public function Index(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {		
			$oParam = array( $Id );
			$oData 	= DB::select('call sp_client_user_index(?)',$oParam);
			
			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." Index";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}

	public function Password(Request $Request){
		$oResponse  = array();
		$oValParams = array(    'Id_User'				=> 'required|int',
								'User_Password'			=> 'required|string|max:250',
								'User_Password_New'		=> 'required|string|max:250'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {			
			$oParam = array(    $Request->input("Id_User"),
								$Request->input("User_Password"),
								$Request->input("User_Password_New")
							);
			$oData = DB::select('call sp_client_user_password(?,?,?)',$oParam);

			//  RESPONSE
			if($oData[0]->Response_Success == 1){
				
			}else{
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);

	}
	
	public function Recover (Request $Request) {
		$oResponse  = array();
		$oValParams = array( 'User_Email' => 'required|string|max:250' );


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {			
			$oParam = [ $Request->input("User_Email") ];

			$oData = DB::select('call sp_client_user_validate(?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 0 && $oData[0]->Response_Status == 406 && $oData[0]->Response_Code == 406 ) {
				
				$oData = DB::select ('CALL sp_client_user_recover(?)', [ $oData[0]->Response_Id ]);
				try {
					$Variables	= [
						"Lang" 			=> 1,
						"User"			=> $oData[0]->Response_User_Email,
						"Password" 		=> $oData[0]->Response_Password,
						'WebUrl'		=> BookingMailSender::getClientWebUrl()[0]->Credential_Value,
						'ResourcesUrl'	=> BookingMailSender::getResourcesUrl()[0]->Credential_Value
					];

					$oMail_User             = new c_Mail_User;
					$oMail_User->Type 		= 4;
					$oMail_User->Subject 	= "Recover Password";
					$oMail_User->Content 	= $Variables;

					if (config('var.SEND_AUTO_ACCESSDATA')) {
						Mail::to($oData[0]->Response_User_Email)->send($oMail_User);
					} else {
						Mail::to(config('var.SEND_EMAIL_ACCESSDATA'))->send($oMail_User);
					}
				} catch (\Throwable $t) {
				}
			} else {
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= NULL;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}

	public function Verification(Request $Request){
        $Password  = array();
		$oResponse  = array();
		$oValParams = array( 'User_Email' => 'required|string|max:250' );


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {			
			$oParam = array(    $Request->input("User_Email")
							);

			$oData = DB::select('call sp_client_user_validate(?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
			} else {
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= NULL;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
		
	}

	public function Selector(Request $Request,$Id){
		if( is_numeric($Id) ){
			return SELF::Index( $Request,$Id );
		}else{
			return SELF::List( $Request,$Id );
		}
	}
	
}