<?php
namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;

use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use Intervention\Image\ImageManagerStatic as Image;

class c_Passenger extends Controller
{
	private $oDomain;

	public function __construct()
	{
		$this->oDomain = "Passenger";
	}
	

	public function Update(Request $Request){
		//return $Request->file('Image')->getClientOriginalExtension();
		$oResponse      = array();
		$oValParams     = array(    'Id_Passenger'		        => 'required|int',
									'Passenger_Name'		    => 'required|string|max:100',
									'Passenger_LastName'	    => 'required|string|max:100',
									'Passenger_Email'			=> 'required|string|max:250',
									'Passenger_Phone'			=> 'required|string|max:50',
									'Passenger_Gender'			=> 'required|int',
									'Passenger_DOB'			    => 'required|string',
									'Passenger_NoDocument'		=> 'required|string|max:20',
									'Passenger_Restriction'     => 'string',
									'Passenger_Extras'			=> 'string',
									'Passenger_ImgDocument1'	=> 'required|image|mimes:'.config("var.MIME_IMG"),
									'Id_TypeDocument'			=> 'required|int',
									'Id_UserCountry'			=> 'required|int',
								);
		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);

		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			
			$oResponse = SELF::Image_Upload(1,$Request);

			if($oResponse["RespCode"] == 200){
				
				$Passenger_ImgDocument1		= $oResponse["Image_Name"];

				$oParam     = array(    			$Request->input("Id_Passenger"),
										Str::title( $Request->input("Passenger_Name") ),
										Str::title( $Request->input("Passenger_LastName") ),
													$Request->input("Passenger_Email"),
													$Request->input("Passenger_Phone"),
													$Request->input("Passenger_Gender"),
													$Request->input("Passenger_DOB"),
													$Request->input("Passenger_NoDocument"),
													$Request->input("Passenger_Restriction"),
													$Request->input("Passenger_Extras"),
													$Request->input("Id_TypeDocument"),
													$Request->input("Id_UserCountry"),
													$Passenger_ImgDocument1	
									);
				$oData  = DB::select('call sp_client_passenger_update(?,?,?,?,?,?,?,?,?,?,?,?,?)',$oParam);
				
				//  RESPONSE
				if($oData[0]->Response_Success == 1){
								
				}else{
					
				}
			}

			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}
	
	public function Index(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			
			$Path_ImgDocument1_Thumb	= config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT1_THUMB");
			$Path_ImgDocument1_Large	= config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT1_LARGE");
			$Path_ImgDocument2_Thumb	= config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT2_THUMB");
			$Path_ImgDocument2_Large	= config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT2_LARGE");

			$oParam 		= array(	$Id ,
										$Path_ImgDocument1_Thumb,
										$Path_ImgDocument1_Large,
										$Path_ImgDocument2_Thumb,
										$Path_ImgDocument2_Large
									);
			$oData 			= DB::select('call sp_client_passenger_index(?,?,?,?,?)',$oParam);
			
			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." Index";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}

	public function List(Request $Request, $Id_Booking){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id_Booking,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {	
			
			$Path_ImgDocument1_Thumb	= config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT1_THUMB");
			$Path_ImgDocument1_Large	= config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT1_LARGE");
			$Path_ImgDocument2_Thumb	= config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT2_THUMB");
			$Path_ImgDocument2_Large	= config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT2_LARGE");

			$oParam = array( 		'all', 
									$Id_Booking,
									$Path_ImgDocument1_Thumb,
									$Path_ImgDocument1_Large,
									$Path_ImgDocument2_Thumb,
									$Path_ImgDocument2_Large
								);
			$oData  = DB::select('call sp_client_passenger_list(?,?,?,?,?,?)',$oParam); 
			
			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." Index";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}

	public function TokenizedUpdate (Request $Request, $Booking_Token) {
		$oResponse      = array();
		$oValParams     = array(    'Id_Passenger'		        => 'required|int',
									'Passenger_Name'		    => 'required|string|max:100',
									'Passenger_LastName'	    => 'required|string|max:100',
									'Passenger_Email'			=> 'string|max:250',
									'Passenger_Phone'			=> 'string|max:50',
									'Passenger_Gender'			=> 'required|int',
									'Passenger_DOB'			    => 'required|string',
									'Passenger_NoDocument'		=> 'required|string|max:20',
									'Passenger_Restriction'     => 'string',
									'Passenger_Extras'			=> 'string',
									'Passenger_ImgDocument1'	=> 'image|mimes:'.config("var.MIME_IMG"),
									'Id_TypeDocument'			=> 'required|int',
									'Id_UserCountry'			=> 'required|int'
								);
		$oResponse = ParamsValidator::Validate_Token($Booking_Token, $this->oDomain);

		if ($oResponse['Response_Code'] == 200) {
			// VALIDANDO DATOS
			$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);

			//  INGRESANDO DATOS
			if ($oResponse["Response_Code"] == 200) {
				
				$oBooking = DB::select ('CALL sp_booking_search_token(?)', [ $Booking_Token ]);

				if (count ($oBooking) && isset ($oBooking[0]->Id_Booking)) {

					$oResponse = SELF::Image_Upload(1,$Request);

					if ($oResponse["RespCode"] == 200) {

						$Passenger_ImgDocument1		= $oResponse["Image_Name"];

						$oParam     = array(    			$Request->input("Id_Passenger"),
												Str::title( $Request->input("Passenger_Name") ),
												Str::title( $Request->input("Passenger_LastName") ),
															$Request->input("Passenger_Email"),
															$Request->input("Passenger_Phone"),
															$Request->input("Passenger_Gender"),
															$Request->input("Passenger_DOB"),
															$Request->input("Passenger_NoDocument"),
															$Request->input("Passenger_Restriction"),
															$Request->input("Passenger_Extras"),
															$Request->input("Id_TypeDocument"),
															$Request->input("Id_UserCountry"),
															$Passenger_ImgDocument1	
											);
						$oData  = DB::select('call sp_client_passenger_update(?,?,?,?,?,?,?,?,?,?,?,?,?)', $oParam);
					}

					$oResponse["Response_Status"]			= $oData[0]->Response_Status;
					$oResponse["Response_Code"]				= $oData[0]->Response_Code;
					$oResponse["Response_Domain"]			= $this->oDomain;
					$oResponse["Response_Message"]			= $oData[0]->Response_Message;
					$oResponse["Response_Data"]				= null;
					$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
					$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
				} else {
					$oResponse["Response_Status"]			= 406;
					$oResponse["Response_Code"]				= 406;
					$oResponse["Response_Domain"]			= $this->oDomain;
					$oResponse["Response_Message"]			= 'Booking Token doesn\'t exists';
					$oResponse["Response_Data"]				= NULL;
					$oResponse["Response_Error_Message"]	= 'Booking Token doesn\'t exists';
					$oResponse["Response_Error_Reason"]		= 'Booking Token doesn\'t exists';
				}
				
			}
		}
		

		return ResponseBuilder::Response($oResponse);
	}

	public function TokenizedIndex (Request $Request, $Booking_Token, $Id) {
		$oResponse      = array();
		
		$oResponse = ParamsValidator::Validate_Token($Booking_Token, $this->oDomain);

		if ($oResponse['Response_Code'] == 200) {

			$Path_ImgDocument1_Thumb	= config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT1_THUMB");
			$Path_ImgDocument1_Large	= config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT1_LARGE");
			$Path_ImgDocument2_Thumb	= config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT2_THUMB");
			$Path_ImgDocument2_Large	= config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT2_LARGE");

			$oParam 		= array(	$Id ,
										$Path_ImgDocument1_Thumb,
										$Path_ImgDocument1_Large,
										$Path_ImgDocument2_Thumb,
										$Path_ImgDocument2_Large
									);
			$oData 			= DB::select('call sp_client_passenger_index(?,?,?,?,?)',$oParam);
			
			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." Index";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}
		

		return ResponseBuilder::Response($oResponse);
	}

	public function TokenizedList (Request $Request) {
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request ($Request, [
			'Booking_Token' => 'string'
		], $this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			

			$oData = [];

			$oBooking = array_map (
				function ($booking) {
					$Path_ImgDocument1_Thumb	= config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT1_THUMB");
					$Path_ImgDocument1_Large	= config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT1_LARGE");
					$Path_ImgDocument2_Thumb	= config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT2_THUMB");
					$Path_ImgDocument2_Large	= config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT2_LARGE");
					$Path_Country_Thumb			= config("var.PATH_PUBLIC").config("var.USER_COUNTRY_THUMB");
					$oParam = array( 		'all', 
											$booking->Id_Booking,
											$Path_ImgDocument1_Thumb,
											$Path_ImgDocument1_Large,
											$Path_ImgDocument2_Thumb,
											$Path_ImgDocument2_Large
										);
					$booking->Passenger		= array_map (function($passenger) use ($Path_Country_Thumb) {
						$passenger->UserCountry_Img_Thumb = $Path_Country_Thumb . $passenger->UserCountry_Img;
						return $passenger;
					}, DB::select ('call sp_client_passenger_list(?,?,?,?,?,?)',	$oParam));
					$booking->Country		= DB::select ('CALL sp_client_user_country_list(?)',			[ $Path_Country_Thumb ]);
					$booking->DocumentType	= DB::select ('call sp_client_type_document_list(?)',		[ $booking->Id_Language ]);
					return $booking;
				},
				DB::select ('CALL sp_booking_search_token(?)', [ $Request->input('Booking_Token', '') ])
			);
				
			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." Index";
			$oResponse["Response_Data"]				= $oBooking;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
			
			
		}

		return ResponseBuilder::Response($oResponse);
	}


	public static function Image_Index( $Id_Passenger){
		$Path_ImgDocument1_Thumb	= config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT1_THUMB");
		$Path_ImgDocument1_Large	= config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT1_LARGE");
		$Path_ImgDocument2_Thumb	= config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT2_THUMB");
		$Path_ImgDocument2_Large	= config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT2_LARGE");

		$oParam = array( 	$Id_Passenger ,
							$Path_ImgDocument1_Thumb,
							$Path_ImgDocument2_Large,
							$Path_ImgDocument2_Thumb,
							$Path_ImgDocument2_Large
						);
		$oData 	= DB::select('call sp_passenger_index(?,?,?,?,?)',$oParam);

        return $oData;
	}
	public static function Image_Upload($Type, Request $Request){

        // ----------------------------------------------------------------------------------------------------------------------------------
        // INICIA VARIABLES DE FUNCCION
        // ----------------------------------------------------------------------------------------------------------------------------------
        $oResponse      = array();
        $oData          = array();

        $Image_Input    = $Type == 1 ? "Passenger_ImgDocument1" : "Passenger_ImgDocument2";
		$Image_Prefix   = $Type == 1 ? "PAX_DOC1_" : "PAX_DOC2_";
		
        $Path_Temp      			= config("var.PATH_PRIVATE").config("var.PATH_TEMP");
		$Path_ImgDocument_Thumb		= $Type == 1 ? config("var.PASSENGER_IMGDOCUMENT1_THUMB") : config("var.PASSENGER_IMGDOCUMENT2_THUMB");
		$Path_ImgDocument_Large		= $Type == 1 ? config("var.PASSENGER_IMGDOCUMENT1_LARGE") : config("var.PASSENGER_IMGDOCUMENT2_LARGE");

		$Path_ImgDocument_Thumb		= config("var.PATH_PRIVATE").$Path_ImgDocument_Thumb;
		$Path_ImgDocument_Large		= config("var.PATH_PRIVATE").$Path_ImgDocument_Large;

        // ----------------------------------------------------------------------------------------------------------------------------------
        // OBTIENE VALOR DE LA IMAGEN ACTUAL
        // ----------------------------------------------------------------------------------------------------------------------------------

        if ($Request->input("Id_Passenger")) {
            $oData      = SELF::Image_Index($Request->input("Id_Passenger"));
        }

        // ----------------------------------------------------------------------------------------------------------------------------------
        // SUBE ARCHIVO NUEVO O DEVUELVE URL DE ARCHIVO ACTUAL
        // ----------------------------------------------------------------------------------------------------------------------------------

        if( $Request->hasFile( $Image_Input ) ){

            $Image_Ext      = $Request->file( $Image_Input )->getClientOriginalExtension();
            $Image_Name     = $Image_Prefix.date("ymd_His")."_".str_pad($Request->input("Id_Passenger"),11,"0",STR_PAD_LEFT).".".$Image_Ext;

            if ($Request->file( $Image_Input )->move($Path_Temp, $Image_Name)) {
                //
                //  Redimensiona Imagen Thumb
                //
				$Image_Thumb = Image::make($Path_Temp.$Image_Name);
				$Image_Thumb->resize(config("var.THUMB_W"),config("var.THUMB_H"));
				$Image_Thumb->save($Path_ImgDocument_Thumb.$Image_Name);
				

				//
                //  SUBE IMAGEN LARGE
                //
                $Image_Large = Image::make($Path_Temp.$Image_Name);
                $Image_Large->save($Path_ImgDocument_Large.$Image_Name);
                

                //
                //  ELIMINA TEMPORAL
                //
				unlink($Path_Temp.$Image_Name);
				

				//
				//	ELIMINA IMAGEN ANTIGUA
				//
				SELF::Image_Remove( $Path_ImgDocument_Thumb, $Type == 1 ? $oData[0]->Passenger_ImgDocument1 : $oData[0]->Passenger_ImgDocument2 );
				SELF::Image_Remove( $Path_ImgDocument_Large, $Type == 1 ? $oData[0]->Passenger_ImgDocument1 : $oData[0]->Passenger_ImgDocument2 );


                //
                //  RESPONSE
                //
                $oResponse["RespCode"]      = 200;
                $oResponse["Image_Name"]    = $Image_Name;
                $oResponse["RespMessage"]   = null;
                $oResponse["RespData"]      = null;
                $oResponse["ErDomain"]      = null;
                $oResponse["ErReason"]      = null;
                $oResponse["ErMessage"]     = null;
            }else{
                $oResponse["RespCode"]      = 422;
                $oResponse["Image_Name"]    = "";
                $oResponse["RespMessage"]   = "Error uploading image.";
                $oResponse["RespData"]      = null;
                $oResponse["ErDomain"]      = 'Image';
                $oResponse["ErReason"]      = "Error uploading image.";
                $oResponse["ErMessage"]     = "";
            }
        }else{
            $oResponse["RespCode"]      = 200;
            $oResponse["Image_Name"]    = $Type == 1 ? $oData[0]->Passenger_ImgDocument1 : $oData[0]->Passenger_ImgDocument2;
            $oResponse["RespMessage"]   = null;
            $oResponse["RespData"]      = null;
            $oResponse["ErDomain"]      = null;
            $oResponse["ErReason"]      = null;
            $oResponse["ErMessage"]     = null;
        }

        return $oResponse;
	}
	public static function Image_Remove($Image_Path, $Image_Name){
		if($Image_Name != "")
		{
			if (file_exists ($Image_Path.$Image_Name))
			{
				if (unlink($Image_Path.$Image_Name)){
					return true;
				}else{
					return false;
				}
			}
		}
		else
		{
            return false;
        }
    }

}