<?php

namespace App\DBTestSupport;

use Illuminate\Support\Facades\DB;

class UserMother {
    
    public static function buildWeb1($id = 1, $idTypeDocument = 1, $idUserCountry = 1) {
        return [
            'Id_User'					=> $id,
            'User_DateCreate'			=> date('Y-m-d H:i:s'),
            'User_Name'					=> 'adsdss',
            'User_LastName'				=> 'asdasd',
            'User_Email'				=> 'asdas@asdas',
            'User_Password'				=> sha1('payment'),
            'User_PhoneCode'			=> '123',
            'User_Phone'				=> '123452231',
            'User_NoDocument'			=> '1234596789',
            'User_Address'				=> 'asdasd',
            'User_ContactName'			=> 'awasdas', 
            'User_ContactPhone'			=> '6484984',
            'User_Type'					=> 1, // web 1, endosador 2
            'User_Status'				=> 2,
            'Id_TypeDocument'			=> $idTypeDocument,
            'Id_UserCountry'			=> $idUserCountry,
        ];
    }
    
    public static function build2($id = 1, $idTypeDocument = 1, $idUserCountry = 1) {
        return [
            'Id_User'					=> $id,
            'User_DateCreate'			=> date('Y-m-d H:i:s'),
            'User_Name'					=> 'zcxxc',
            'User_LastName'				=> 'xzccx',
            'User_Email'				=> 'zxccxc@asdas',
            'User_Password'				=> sha1('mother'),
            'User_PhoneCode'			=> '87987',
            'User_Phone'				=> '97798879',
            'User_NoDocument'			=> '987654312',
            'User_Address'				=> 'xzczxcx',
            'User_ContactName'			=> 'zzczxc', 
            'User_ContactPhone'			=> '313165132',
            'User_Type'					=> 1, // web 1, endosador 2
            'User_Status'				=> 2,
            'Id_TypeDocument'			=> $idTypeDocument,
            'Id_UserCountry'			=> $idUserCountry,
        ];
    }

    public static function pushWeb1($id = 1) {
        return self::push(self::buildWeb1($id));
    }

    public static function push2($id = 1) {
        return self::push(self::build2($id));
    }

    private static function push($object) {
        DB::select("CALL `sp_user_insert` (?,?,?,?,?,?,?,?,?,?,?,?,?)", [
            $object['User_Name'],
            $object['User_LastName'],
            $object['User_Email'],
            $object['User_PhoneCode'],
            $object['User_Phone'],
            $object['User_NoDocument'],
            $object['User_Address'],
            $object['User_ContactName'],
            $object['User_ContactPhone'],
            $object['User_Type'],
            $object['User_Status'],
            $object['Id_TypeDocument'],
            $object['Id_UserCountry'],
        ]);
        return $object;
    }

}