<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Illuminate\Support\Facades\DB;

class UpgradeMother
{
    public static function build1($idTypeUpgrade = null, $id = 1)
    {
        $faker = \Faker\Factory::create();
        return [
            'Id_Upgrade' => $id,
            'Upgrade_Code' => Util::generateString(10),
            'Upgrade_Name' => $faker->text(rand(5, 250)),
            'Upgrade_Feature' => '',
            'Upgrade_Price' => $faker->randomNumber(4),
            'Upgrade_PriceConfidential' => $faker->randomNumber(4),
            'Upgrade_OneWay' => $faker->randomElement([1, 2]),
            'Upgrade_Status' => 2,
            'Upgrade_Lock' => 0,
            'Id_TypeUpgrade' => $idTypeUpgrade ?? TypeUpgradeMother::push1()['Id_TypeUpgrade']
        ];
    }

    public static function push1($idTypeUpgrade = null, $id = 1)
    {
        return self::push(self::build1($idTypeUpgrade, $id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_upgrade_insert`(?,?,?,?,?,?,?,?)", [
            $object['Upgrade_Code'],
            $object['Upgrade_Name'],
            $object['Upgrade_Feature'],
            $object['Upgrade_Price'],
            $object['Upgrade_PriceConfidential'],
            $object['Upgrade_OneWay'],
            $object['Upgrade_Status'],
            $object['Id_TypeUpgrade'],
        ]);
        $object['Id_Upgrade'] = $response[0]->Response_Id;
        return $object;
    }
}
