<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class TypePaymentMother
{
    public static function build1($id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_TypePayment'            => $id,
            'TypePayment_Name'          => $faker->text(rand(5, 100)),
            'TypePayment_Abrv'          => Util::generateString(4),
            'TypePayment_Asset'         => $faker->text(rand(5, 100)),
            'TypePayment_RequireGateway' => $faker->randomElement([1, 2]),
            'TypePayment_Status'        => 2
        ];
    }

    public static function push1($id = 1)
    {
        return self::push(self::build1($id));
    }

    public static function push($object)
    {
        $response = DB::select("CALL `sp_type_payment_insert` (?,?,?,?,?)", [
            $object['TypePayment_Name'],
            $object['TypePayment_Abrv'],
            $object['TypePayment_Asset'],
            $object['TypePayment_RequireGateway'],
            $object['TypePayment_Status']
        ]);
        $object['Id_TypePayment'] = $response[0]->Response_Id;
            
        return $object;
    }

    public static function tablesToClear()
    {
        return [ TC::type_payment, TC::type_payment_transl ];
    }
}
