<?php

namespace App\DBRealTestSupport;

use App\Config\DatabaseConfig;
use Illuminate\Support\Facades\DB;

class TableCreation
{

    private static $createdTables = [];

    public static function reset()
    {
        self::$createdTables = [];
        $db = DatabaseConfig::db();
        $db->query("SET FOREIGN_KEY_CHECKS = 0;
            SET GROUP_CONCAT_MAX_LEN=32768;
            SET @tables = NULL;
            SELECT GROUP_CONCAT('`', table_name, '`') INTO @tables
            FROM information_schema.tables
            WHERE table_schema = (SELECT DATABASE());        
            SELECT IFNULL(@tables,'dummy') INTO @tables;

            SET @tables = CONCAT('DROP TABLE IF EXISTS ', @tables);
            PREPARE stmt FROM @tables;
            EXECUTE stmt;
            DEALLOCATE PREPARE stmt;
            SET FOREIGN_KEY_CHECKS = 1");
    }
    
    public static function createTable($tableName)
    {
        
        if (array_key_exists($tableName, self::$createdTables)) {
            return;
        }
        
        $sqlDir = self::sqlDir();

        $tableDir = $sqlDir . $tableName . '.sql';
        $content = file_get_contents($tableDir);
        
        $db = DatabaseConfig::db();
        $db->query($content);
        self::$createdTables[$tableName] = true;
    }

    public static function cDatabase()
    {
        self::createTable('db_salkantay');
    }

    public static function sqlDir():string
    {
        $cut = DIRECTORY_SEPARATOR;
        return __DIR__ . "$cut";
    }

    public const language = 't_language';
    public const type_document = 't_type_document';
    public const type_document_transl = 't_type_document_transl';
    public const admin_role = 't_admin_role';
    public const admin_role_auth = 't_admin_role_auth';
    public const country = 't_country';
    public const DIRECTORY = 't_directory';
    public const state = 't_state';
    public const city = 't_city';
    public const ADMIN = 't_admin';
    public const admin_session = 't_admin_session';
    public const credential = 't_credential';
    public const invoice = 't_invoice';
    public const invoice_detail = 't_invoice_detail';
    public const invoice_fee = 't_invoice_fee';
    public const invoice_fee_detail = 't_invoice_fee_detail';
    public const package = 't_package';
    public const package_tour = 't_package_tour';
    public const package_fee = 't_package_fee';
    public const package_rate = 't_package_rate';
    public const package_transl = 't_package_transl';
    public const passenger = 't_passenger';
    public const user_country = 't_user_country';
    public const category_tour = 't_category_tour';
    public const type_tour = 't_type_tour';
    public const type_tour_transl = 't_type_tour_transl';
    public const type_rate = 't_type_rate';
    public const type_rate_transl = 't_type_rate_transl';
    public const type_payment = 't_type_payment';
    public const type_payment_transl = 't_type_payment_transl';
    public const user_package_rate = 't_user_package_rate';
    public const tour = 't_tour';
    public const tour_transl = 't_tour_transl';
    public const group = 't_group';
    public const booking_relationship = 't_booking_relationship';
    public const booking_referred_from = 't_booking_referred_from';
    public const user = 't_user';
    public const booking = 't_booking';
    public const booking_tour = 't_booking_tour';
    public const booking_tour_passenger = 't_booking_tour_passenger';
    public const type_upgrade = 't_type_upgrade';
    public const type_upgrade_transl = 't_type_upgrade_transl';
    public const upgrade = 't_upgrade';
    public const upgrade_transl = 't_upgrade_transl';
    public const booking_upgrade = 't_booking_upgrade';
    public const booking_upgrade_passenger = 't_booking_upgrade_passenger';
    public const booking_equipment = 't_booking_equipment';
    public const cash_movement = 't_cash_movement';
    public const cash_movement_detail = 't_cash_movement_detail';
    public const htl_camp = 't_htl_camp';
    public const htl_room = 't_htl_room';
    public const htl_usage = 't_htl_usage';
    public const htl_usage_passenger = 't_htl_usage_passenger';
    public const tour_htl_camp = 't_tour_htl_camp';
    public const type_item = 't_type_item';
    public const type_equipment = 't_type_equipment';
    public const type_equipment_transl = 't_type_equipment_transl';
    public const item = 't_item';
    public const equipment = 't_equipment';
    public const equipment_transl = 't_equipment_transl';
    public const package_tour_equipment = 't_package_tour_equipment';
    public const pax_information = 't_pax_information';
    public const pax_information_passenger = 't_pax_information_passenger';
    public const question = 't_question';
    public const QUESTION_TRANSL = 't_question_transl';
    public const group_passenger = 't_group_passenger';
    public const group_provider = 't_group_provider';
    public const type_provider = 't_type_provider';
    public const redistribution = 't_redistribution';
    public const redistribution_detail = 't_redistribution_detail';
    public const passenger_review = 't_passenger_review';
    public const PROVIDER = 't_provider';
    public const TOUR_QUESTION = 't_tour_question';
    public const MODULE_NOTIFICATION = 't_module_notification';
    public const MODULE_NOTIFICATION_PARAM = 't_module_notification_param';
    public const EXTERNAL = 't_external';
    public const EXTERNAL_USER = 't_external_user';
    public const EXTERNAL_USER_PASSENGER = 't_external_user_passenger';
    public const EXTERNAL_REVIEW = 't_external_review';
    public const EXTERNAL_REVIEW_PROVIDER = 't_external_review_provider';
    public const REVIEW_SESSION = 't_review_session';
    public const REVIEW_SESSION_GROUP_PASSENGER = 't_review_session_group_passenger';
    public const LEAD = 't_lead';
    public const LEAD_BOOKING = 't_lead_booking';
    public const LEAD_PASSENGER = 't_lead_passenger';
    public const LEAD_BOOKING_TOUR = 't_lead_booking_tour';
    public const LEAD_BOOKING_TOUR_PASSENGER = 't_lead_booking_tour_passenger';
    public const LEAD_BOOKING_SERVICE = 't_lead_booking_service';
    public const LEAD_BOOKING_SERVICE_PASSENGER = 't_lead_booking_service_passenger';
    public const REVIEW_NOTIFICATION = 't_review_notification';


    public static function clearTables(...$tables)
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        foreach ($tables as $table) {
            DB::statement("DELETE FROM `$table`;");
        }
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
