<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class ReviewSessionMother
{
    
    public static function build1(
        $passengerNoDocument,
        $id = 1
    ) {
        $faker = Factory::create();
        return [
            'Id_ReviewSession' => $id,
            'ReviewSession_Date' => date('Y-m-d H:i:s'),
            'ReviewSession_DateExpire' => date('Y-m-d H:i:s'),
            'ReviewSession_Status' => 2,
            'ReviewSession_Token' => '',
            'Passenger_NoDocument' => $passengerNoDocument
        ];
    }

    public static function push1(
        $passengerNoDocument,
        $id = 1
    ) {
        return self::push(self::build1(
            $passengerNoDocument,
            $id
        ));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_passenger_review_session_insert`(?,@sts,@cod,@msg,@id)", [
            $object['Passenger_NoDocument']
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_ReviewSession'] = $response[0]->{'@id'};
        }
        return $object;
    }

    public static function tablesToClear()
    {
        return [
            TC::EXTERNAL_REVIEW,
            ...PassengerMother::tablesToClear()
        ];
    }
}
