<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class ReviewNotificationMother
{
    
    public static function build1($idGroupPassenger, $idAdmin_Create, $idAdmin_Accept, $id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_ReviewNotification' => $id,
            'ReviewNotification_DateCreate' => date('Y-m-d H:i:s'),
            'ReviewNotification_DateAccept' => date('Y-m-d H:i:s'),
            'ReviewNotification_Description' => $faker->text(rand(5, 250)),
            'ReviewNotification_Response' => $faker->text(rand(5, 250)),
            'ReviewNotification_Status' => $faker->randomElement([1, 2]),
            'Id_ReviewNotification_Parent' => 0,
            'Id_GroupPassenger' => $idGroupPassenger,
            'Id_Admin_Create' => $idAdmin_Create,
            'Id_Admin_Accept' => $idAdmin_Accept,
        ];
    }

    public static function push1($idGroupPassenger, $idAdmin_Create, $idAdmin_Accept, $id = 1)
    {
        return self::push(self::build1($idGroupPassenger, $idAdmin_Create, $idAdmin_Accept, $id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_review_notification_insert`(?,?,?,?,?,@sts,@cod,@msg,@id)", [
            $object['ReviewNotification_Description'],
            $object['ReviewNotification_Status'],
            $object['Id_GroupPassenger'],
            $object['Id_Admin_Create'],
            $object['Id_ReviewNotification_Parent']
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_ReviewNotification'] = $response[0]->{'@id'};
        }
        return $object;
    }

    public static function tablesToClear()
    {
        return array_merge(
            BookingMother::clear(),
            [ TC::REVIEW_NOTIFICATION, TC::group, TC::group_passenger ],
        );
    }
}
