<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;

class PaxInformationPassengerMother
{
    
    public static function build1($idPaxInformation = null, $idPassenger = null, $id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_PaxInformationPassenger'        => $id,
            'PaxInformationPassenger_Remaining' => $faker->randomElement([2, 3, 4, 5]),
            'PaxInformationPassenger_Status'    => $faker->randomElement([1]),
            'Id_PaxInformation'                 => $idPaxInformation,
            'Id_Passenger'                      => $idPassenger,
        ];
    }

    public static function push1($idPaxInformation = null, $idPassenger = null, $id = 1)
    {
        return self::push(self::build1($idPaxInformation, $idPassenger, $id));
    }

    private static function push($object)
    {
        DB::select("CALL `sp_pax_information_passenger_insert`(?,?,?,?,@sts,@cod,@msg,@id)", [
            $object['PaxInformationPassenger_Remaining'],
            $object['PaxInformationPassenger_Status'],
            $object['Id_PaxInformation'],
            $object['Id_Passenger'],
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_PaxInformationPassenger'] = $response[0]->{'@id'};
        }
        return $object;
    }
}
