<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class PassengerMother
{
    
    public static function build1(
        $idBooking,
        $idTypeDocument = null,
        $idUserCountry = null,
        $idTypeRate = null,
        $id = 1
    ) {
        $idTypeRate = $idTypeRate ?? TypeRateMother::push1()['Id_TypeRate'];
        $idTypeDocument = $idTypeDocument ?? TypeDocumentMother::push1()['Id_TypeDocument'];
        $idUserCountry = $idUserCountry ?? UserCountryMother::push1()['Id_UserCountry'];
        $faker = Factory::create();
        return [
            'Id_Passenger'                  => $id,
            'Passenger_DateCreate'          => date('Y-m-d H:i:s'),
            'Passenger_DateEdit'            => date('Y-m-d H:i:s'),
            'Passenger_Name'                => $faker->firstName,
            'Passenger_LastName'            => $faker->lastName,
            'Passenger_Email'               => $faker->email,
            'Passenger_Phone'               => $faker->phoneNumber,
            'Passenger_Gender'              => $faker->randomElement([1, 2]),
            'Passenger_DOB'                 => date('Y-m-d'),
            'Passenger_NoDocument'          => $faker->text(20),
            'Passenger_Restriction'         => '',
            'Passenger_Extras'              => '',
            'Passenger_ImgDocument1'        => '',
            'Passenger_ImgDocument2'        => '',
            'Passenger_Token'               => '',
            'Passenger_Status'              => 2,
            'Passenger_PaymentStatus'       => 1,
            'Passenger_InfoStatus'          => 1,
            'Id_Booking'                    => $idBooking,
            'Id_TypeDocument'               => $idTypeDocument,
            'Id_UserCountry'                => $idUserCountry,
            'Id_TypeRate'                   => $idTypeRate
        ];
    }

    public static function push1($idBooking, $idTypeDocument = null, $idUserCountry = null, $idTypeRate = null, $id = 1)
    {
        return self::push(self::build1($idBooking, $idTypeDocument, $idUserCountry, $idTypeRate, $id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_passenger_insert` (?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [
            $object['Passenger_Name'],
            $object['Passenger_LastName'],
            $object['Passenger_Email'],
            $object['Passenger_Phone'],
            $object['Passenger_Gender'],
            $object['Passenger_DOB'],
            $object['Passenger_NoDocument'],
            $object['Passenger_Restriction'],
            $object['Passenger_Extras'],
            $object['Passenger_Status'],
            $object['Id_Booking'],
            $object['Id_TypeDocument'],
            $object['Id_TypeRate'],
            $object['Id_UserCountry'],
        ]);
        try {
            $object['Id_Passenger'] = $response[0]->Response_Id;
        } catch (\Throwable) {
            dd($response);
        }
        return $object;
    }

    public static function tablesToClear()
    {
        return array_merge(
            BookingMother::clear(),
            [
                TC::passenger
            ]
        );
    }
}
