<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;

class PackageRateMother {
    
    public static function buildPrivate($idPackage, $idTypeRate, $id = 1, $least = null) {
        $faker = Factory::create();
        return [
            'Id_PackageRate' => $id,
            'PackageRate_PaxStart' => 1,
            'PackageRate_PaxEnd' => 10,
            'PackageRate_Price' => isset($least) ? rand(5, $least - 1) : $faker->randomNumber(4),
            'PackageRate_PriceConfidential' => isset($least) ? rand(5, $least - 1) : $faker->randomNumber(4),
            'PackageRate_Type' => 1,
            'PackageRate_Status' => 2,
            'Id_Package' => $idPackage,
            'Id_TypeRate' => $idTypeRate
        ];
    }
    
    public static function build1($idPackage, $idTypeRate, $id = 1) {
        $faker = Factory::create();
        return [
            'Id_PackageRate' => $id,
            'PackageRate_PaxStart' => 1,
            'PackageRate_PaxEnd' => 10,
            'PackageRate_Price' => $faker->randomNumber(4),
            'PackageRate_PriceConfidential' => $faker->randomNumber(4),
            'PackageRate_Type' => 2,
            'PackageRate_Status' => 2,
            'Id_Package' => $idPackage,
            'Id_TypeRate' => $idTypeRate
        ];
    }

    public static function pushPrivate($idPackage, $idTypeRate, $id = 1, $least = null) {
        return self::push(self::buildPrivate($idPackage, $idTypeRate, $id, $least));
    }

    public static function push1($idPackage, $idTypeRate, $id = 1) {
        return self::push(self::build1($idPackage, $idTypeRate, $id));
    }

    private static function push($object) {
        $result = DB::select("CALL `sp_package_rate_insert` (?,?,?,?,?,?,?,?)", [
            $object['PackageRate_PaxStart'],
            $object['PackageRate_PaxEnd'],
            $object['PackageRate_Price'],
            $object['PackageRate_PriceConfidential'],
            $object['PackageRate_Type'],
            $object['PackageRate_Status'],
            $object['Id_Package'],
            $object['Id_TypeRate']
        ]);
        $object['Id_PackageRate'] = $result[0]->Response_Id;
        return $object;
    }

}