<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class PackageMother {

    public static function build1($id = 1) {
        $faker = Factory::create();
        return [
            'Id_Package' => $id,
            'Package_Code' => $faker->text(rand(5, 50)),
            'Package_Name' => Str::title($faker->text(rand(5, 250))),
            'Package_UrlThumbnail' => '',
            'Package_Duration' => rand(1, 5),
            'Package_Availability' => rand(3, 10),
            'Package_PaxRequired' => $faker->randomElement([1, 2]),
            'Package_DOBRequired' => $faker->randomElement([1, 2]),
            'Package_Status' => $faker->randomElement([1, 2]),
            'Package_Endorser' => $faker->randomElement([1, 2]),
        ];
    }

    public static function push1($id = 1) {
        return self::push(self::build1($id));
    }
    
    private static function push($object) {
        $response = DB::select("CALL `sp_package_insert` (?,?,?,?,?,?,?,?,?)", [
            $object['Package_Name'],
            $object['Package_Code'],
            $object['Package_UrlThumbnail'],
            $object['Package_Availability'],
            $object['Package_PaxRequired'],
            $object['Package_DOBRequired'],
            $object['Package_Status'],
            $object['Package_Endorser'],
            $object['Package_Duration']
        ]);
        $object['Id_Package'] = $response[0]->Response_Id;
        return $object;
    }

}