<?php

namespace App\DBRealTestSupport;

use App\Modules\ModuleNotification\Domain\ModuleNotificationType;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class ModuleNotificationMother
{
    public static function build1($module, $idAdminCreate, $idAdminAccept, $id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_ModuleNotification' => $id,
            'ModuleNotification_DateCreate' => date('Y-m-d H:i:s'),
            'ModuleNotification_DateAccept' => date('Y-m-d H:i:s'),
            'ModuleNotification_Description' => $faker->text(rand(5, 250)),
            'ModuleNotification_Type' => $faker->randomElement([ModuleNotificationType::BOOKING_CONFIRMATION]),
            'ModuleNotification_Status' => $faker->randomElement([1, 2]),
            'ModuleNotification_Module' => $module,
            'Id_Admin_Create' => $idAdminCreate,
            'Id_Admin_Accept' => $idAdminAccept
        ];
    }

    public static function push1($module, $idAdminCreate, $idAdminAccept, $id = 1)
    {
        return self::push(self::build1($module, $idAdminCreate, $idAdminAccept, $id = 1));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_module_notification_insert` (?,?,?,?)", [
            $object['ModuleNotification_Description'],
            $object['ModuleNotification_Type'],
            $object['ModuleNotification_Module'],
            $object['Id_Admin_Create']
        ])[0];
        $object['Id_ModuleNotification'] = $response->Response_Id;
        return $object;
    }

    public static function clear()
    {
        return [
            TC::MODULE_NOTIFICATION,
            TC::MODULE_NOTIFICATION_PARAM
        ];
    }
}
