<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class LeadBookingServiceMother
{
    
    public static function build1(
        $idLeadBookingTour,
        $idService,
        $leadBookingServiceType = null,
        $id = 1
    ) {
        $faker = Factory::create();
        $leadBookingServiceType = $leadBookingServiceType ?? $faker->randomElement([1, 2, 3]);
        return [
            'Id_LeadBookingService' => $id,
            'LeadBookingService_Quantity' => $faker->randomElement([1, 2, 3, 4, 5]),
            'LeadBookingService_Type' => $leadBookingServiceType,
            'LeadBookingService_Status' => $faker->randomElement([1, 2]),
            'Id_LeadBookingTour' => $idLeadBookingTour,
            'Id' => $idService
        ];
    }

    public static function push1(
        $idLeadBookingTour,
        $idService,
        $leadBookingServiceType = null,
        $id = 1
    ) {
        return self::push(self::build1($idLeadBookingTour, $idService, $leadBookingServiceType, $id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_lead_booking_service_insert`(?,?,?,?,?,@sts,@cod,@msg,@id)", [
            $object['LeadBookingService_Quantity'],
            $object['LeadBookingService_Type'],
            $object['LeadBookingService_Status'],
            $object['Id_LeadBookingTour'],
            $object['Id']
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_LeadBookingService'] = $response[0]->{'@id'};
        }
        return $object;
    }

    public static function tablesToClear()
    {
        return array_merge(
            [TC::LEAD_BOOKING_SERVICE],
            LeadBookingTourMother::tablesToClear()
        );
    }
}
