<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Illuminate\Support\Facades\DB;

class ItemMother {
    
    public static function build1($idTypeItem = null, $id = 1) {
        $faker = \Faker\Factory::create();
        return [
            'Id_Item' => $id,
            'Item_Name' => $faker->text(rand(5, 250)),
            'Item_Abrv' => Util::generateString(4),
            'Item_Status' => $faker->randomElement([1, 2]),
            'Id_TypeItem' => $idTypeItem ?? TypeItemMother::push1()['Id_TypeItem']
        ];
    }

    public static function push1($idTypeItem = null, $id = 1) {
        return self::push(self::build1($idTypeItem, $id));
    }

    private static function push($object) {
        $response = DB::select("CALL `sp_item_insert` (?,?,?,?)", [
            $object['Item_Name'],
            $object['Item_Abrv'],
            $object['Item_Status'],
            $object['Id_TypeItem']
        ]);
        $object['Id_Item'] = $response[0]->Response_Id;
        return $object;
    }

}