<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;

class GroupPassengerMother
{

    public const BOOKING_TOUR_PASSENGER = 1;
    public const PASSENGER = 2;

    public static function build1($idGroup, $idFound, $id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_GroupPassenger' => $id,
            'GroupPassenger_Type' => 1,
            'Id_Group' => $idGroup,
            'Id' => $idFound
        ];
    }

    public static function push1($idGroup, $idFound, $id = 1)
    {
        return self::push(self::build1($idGroup, $idFound, $id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_group_passenger_insert` (?,?,?)", [
            $object['GroupPassenger_Type'],
            $object['Id_Group'],
            $object['Id'],
        ]);
        $object['Id_GroupPassenger'] = $response[0]->Response_Id;
        return $object;
    }
}
