<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class BookingUpgradePassengerMother
{
    public static function build1($idAdmin, $idBookingUpgrade, $idBookingTourPassenger, $id = 1)
    {
        $faker = \Faker\Factory::create();
        return [
            'Id_BookingUpgradePassenger' => $id,
            'BookingUpgradePassenger_Date' => date('Y-m-d H:i:s'),
            'BookingUpgradePassenger_OnlyReturn' => $faker->randomElement([1, 2]),
            'BookingUpgradePassenger_DateEntry' => date('Y-m-d H:i', time() + rand(100000, 1000000)),
            'BookingUpgradePassenger_Datereturn' => date('Y-m-d H:i', time() + rand(100000, 1000000)),
            'BookingUpgradePassenger_DatePurchase' => date('Y-m-d H:i', time() + rand(100000, 1000000)),
            'BookingUpgradePassenger_Carrier' => $faker->randomElement(['PERU RAIL', 'INCA RAIL']),
            'BookingUpgradePassenger_Code' => Util::generateString(20),
            'BookingUpgradePassenger_Amount' => $faker->randomNumber(4),
            'BookingUpgradePassenger_RoundCarrier' => $faker->randomElement(['PERU RAIL', 'INCA RAIL']),
            'BookingUpgradePassenger_RoundCode' => Util::generateString(20),
            'BookingUpgradePassenger_RoundAmount' => $faker->randomNumber(4),
            'BookingUpgradePassenger_Remark' => $faker->text(rand(5, 250)),
            'BookingUpgradePassenger_Status' => 1,
            'Id_Admin' => $idAdmin,
            'Id_BookingUpgrade' => $idBookingUpgrade,
            'Id_BookingTourPassenger' => $idBookingTourPassenger
        ];
    }

    public static function push1($Id_Admin, $Id_BookingUpgrade, $Id_BookingTourPassenger, $id = 1)
    {
        return self::push(self::build1($Id_Admin, $Id_BookingUpgrade, $Id_BookingTourPassenger, $id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_booking_upgrade_passenger_insert`(?,?,?)", [
            $object['Id_BookingUpgrade'],
            $object['pId_BookingTourPassenger'],
            1
        ]);
        $object['Id_BookingUpgradePassenger'] = $response[0]->Response_Id;
        return $object;
    }

    public static function clear()
    {
        return array_merge(
            BookingMother::clear(),
            [
                TC::type_upgrade,
                TC::type_upgrade_transl,
                TC::upgrade,
                TC::upgrade_transl,
                TC::booking_upgrade,
                TC::booking_upgrade_passenger,
            ]
        );
    }
}
