<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class BookingTourPassengerMother
{
    public static function build1($Id_BookingTour, $Id_Passenger, $id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_BookingTourPassenger' => $id,
            'BookingTourPassenger_Status' => $faker->randomElement([1, 2]),
            'Id_BookingTour' => $Id_BookingTour,
            'Id_Passenger' => $Id_Passenger
        ];
    }

    public static function push1($Id_BookingTour, $Id_Passenger, $id = 1)
    {
        return self::push(self::build1($Id_BookingTour, $Id_Passenger, $id));
    }

    private static function push($object)
    {
        DB::select("CALL `sp_lead_booking_tour_passenger_insert`(?,?,?,@sts,@cod,@msg,@id)", [
            $object['BookingTourPassenger_Status'],
            $object['Id_BookingTour'],
            $object['Id_Passenger']
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_BookingTourPassenger'] = $response[0]->{'@id'};
        }
        return $object;
    }

    public static function tablesToClear()
    {
        return array_merge(
            [TC::LEAD_BOOKING_TOUR_PASSENGER],
            BookingTourMother::tablesToClear(),
            PassengerMother::tablesToClear(),
        );
    }
}
