<?php

namespace App\DBRealTestSupport;

use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class BookingMother
{

    public static function pushRelationshipAndReferredFrom()
    {
        DB::statement("INSERT INTO `t_booking_relationship` (
            `Id_BookingRelationship`,
            `BookingRelationship_Name`,
            `BookingRelationship_Abrv`,
            `BookingRelationship_Lock`,
            `BookingRelationship_Status`)
            VALUE 
            (1, 'Ninguno', 'NONE', 2, 2)");
        DB::statement("INSERT INTO `t_booking_referred_from` (
            `Id_BookingReferredFrom`,
            `BookingReferredFrom_Name`,
            `BookingReferredFrom_Abrv`,
            `BookingReferredFrom_Lock`,
            `BookingReferredFrom_Status`)
            VALUE
            (1, 'Ninguno', 'NONE', 2, 2)");
    }
    
    public static function build1(
        $idAdmin,
        $idGuideLanguage,
        $idLanguage,
        $idUser,
        $idBookingRelationship = 1,
        $idBookingReferredFrom = 1,
        $id = 1
    ) {
        return [
            'Id_Booking'                    => $id,
            'Booking_Date'                  => date('Y-m-d H:i:s'),
            'Booking_DateStart'             => date('Y-m-d'),
            'Booking_DateBriefing'          => date('Y-m-d H:i:s', time() + 10*60*60),
            'Booking_PlaceBriefing'         => 'Place Briefing',
            'Booking_Code'                  => 'Code',
            'Booking_HistoryChanges'        => '',
            'Booking_Hotel'                 => '',
            'Booking_Observation'           => '',
            'Booking_Receipt'               => 1,
            'Booking_Type'                  => 2,
            'Booking_LastMinute'            => 2,
            'Booking_Status'                => 1,
            'Booking_ManuallyConfirmed'     => 1,
            'Booking_InPerson'              => 2,
            'Booking_Token'                 => '',
            'Id_Admin'                      => $idAdmin,
            'Id_GuideLanguage'              => $idGuideLanguage,
            'Id_Language'                   => $idLanguage,
            'Id_User'                       => $idUser,
            'Id_BookingRelationship'        => $idBookingRelationship,
            'Id_BookingReferredFrom'        => $idBookingReferredFrom,
        ];
    }

    public static function push1(
        $idAdmin,
        $idGuideLanguage,
        $idLanguage,
        $idUser,
        $token,
        $idBookingRelationship = 1,
        $idBookingReferredFrom = 1,
        $id = 1
    ) {
        return self::push(
            self::build1(
                $idAdmin,
                $idGuideLanguage,
                $idLanguage,
                $idUser,
                $idBookingRelationship,
                $idBookingReferredFrom,
                $id
            ),
            $token
        );
    }

    private static function push($object, $token = '')
    {
        $response = DB::select("CALL `sp_booking_insert` (?,?,?,?,?,?,?,?,?)", [
            $object['Booking_DateStart'],
            $object['Booking_Receipt'],
            $object['Booking_Type'],
            $object['Booking_Observation'],
            $object['Id_Language'],
            $object['Id_GuideLanguage'],
            $object['Id_User'],
            $object['Booking_InPerson'],
            $token
        ]);
        $object['Id_Booking'] = $response[0]->Response_Id;
        return $object;
    }

    public static function clear()
    {
        return array_merge([
            TC::country, TC::state, TC::city, TC::type_tour, TC::category_tour, TC::tour, TC::group,
            TC::booking, TC::booking_referred_from, TC::booking_relationship, TC::package_tour, TC::invoice,
            TC::invoice_fee, TC::invoice_detail, TC::invoice_fee_detail,TC::package, TC::package_fee,
            TC::package_rate, TC::package_transl, TC::passenger, TC::tour_transl, TC::type_rate, TC::type_rate_transl,
            TC::type_tour_transl, TC::user_package_rate, TC::booking_tour_passenger, TC::booking_tour, TC::type_payment,
            TC::type_payment_transl, TC::type_item, TC::type_equipment, TC::item, TC::equipment,
            TC::package_tour_equipment, TC::booking_equipment, TC::cash_movement, TC::cash_movement_detail,
            TC::equipment_transl, TC::type_equipment_transl, TC::credential, TC::language,
        ], ModuleNotificationMother::clear());
    }
}
